import bcrypt from 'bcryptjs';
import dotenv from 'dotenv';
import db from './db.js';

dotenv.config();

async function setup() {
  console.log('🔧 Setting up VorAI License Server...\n');

  try {
    // Initialize database tables
    await db.initDatabase();

    // Create default admin user
    const adminEmail = process.env.ADMIN_EMAIL || 'admin@vorai.com';
    const adminPassword = process.env.ADMIN_PASSWORD || 'admin123';
    
    const existingAdmin = await db.query('SELECT id FROM admins WHERE email = $1', [adminEmail]);
    
    if (existingAdmin.rows.length === 0) {
      const hashedPassword = await bcrypt.hash(adminPassword, 10);
      await db.query(
        'INSERT INTO admins (email, password, name, role) VALUES ($1, $2, $3, $4)',
        [adminEmail, hashedPassword, 'Administrator', 'admin']
      );
      console.log(`✅ Created admin user: ${adminEmail}`);
      console.log(`   Password: ${adminPassword}`);
      console.log('   ⚠️  Please change this password after first login!\n');
    } else {
      console.log(`ℹ️  Admin user already exists: ${adminEmail}\n`);
    }

    console.log('✅ Setup complete!\n');
    console.log('To start the server, run:');
    console.log('   npm start\n');
    console.log('Or for development:');
    console.log('   npm run dev\n');

    process.exit(0);
  } catch (error) {
    console.error('❌ Setup failed:', error);
    process.exit(1);
  }
}

setup();
